<?php

require_once 'config.php';

require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once 'tmdb.class.php';

header('Content-Type: application/json');

$db = new db();
$url = "";
$years = array("2020","2019");
$active_channels = array();
$vod_groups = array();
$itv_groups = array();
$itv_group_ids = array();
$nitro_groups = array(
    "NETWORKS",
    "ENTERTAINMENT",
    "MOVIES PREMIUM",
    "NEWS",
    "KIDS",
    "SPORTS (USA/CA)",
    "UK SPORTS & INTL",
    "BEIN & ELEVEN SPORTS",
    "SKY SPORTS",
    "ESPN+ & COLLEGE EXTRA",
    "NBA LEAGUE PASS",
    "NHL CENTER ICE",
    "MLB EXTRA INNINGS",
    "NBC GOLD",
    "NFL SUNDAY TICKET",
    "PPV EVENTS (DAY OF ONLY)",
    "UFC FIGHT PASS",
    "CANADA",
    "U.K.",
    "PPV MOVIES",
    "MUSIC CHOICE",
    "MOVIES PLUS (DUAL AUDIO)",
    "24/7"
);

$ignore_groups = array(
    "PUNJABI",
    "ARABIC (NEW)",
    "FILIPINO/TAGALOG",
    "HINDI SERIALS",
    "ASIAN CINEMA"
);

$server = 1;
$items = array();

//get DB movies
$movies = array();
$moviesIds = array();
$moviesData = $db->read('video','is_series LIKE ?',array("0"));
foreach ($moviesData as $movieData){
    $movies[$movieData["name"]] = $movieData["name"];
    $moviesIds[] = $movieData["id"];
}


//get DB series
$series = array();
$seriesIds = array();
$seriesData = $db->read('video','is_series LIKE ?',array("1"));
foreach ($seriesData as $serieData){
    $series[$serieData["name"]] = $serieData["name"];
    $seriesIds[] = $serieData["id"];
}

//get DB channels
$channels = array();
$channelIds = array();
//$channelsData = $db->read('itv');
$channelsData = $db->read('itv','server = ?',array($server));
foreach ($channelsData as $channelData){
    $channels[strtoupper($channelData["name"])] = strtoupper($channelData["name"]);
    $channelIds[] = $channelData["streamId"];
}


$db_vod_categories = array();
$categoriesData = $db->read('media_category');
foreach ($categoriesData as $categoryData){
    $db_vod_categories[strtoupper($categoryData["category_name"])] = $categoryData["id"];
}


//get DB live categories
$db_categories = array();
$categoriesData = $db->read('tv_genre');
foreach ($categoriesData as $categoryData){
        $db_categories[strtoupper($categoryData["title"])] = $categoryData["id"];
}

$jioVodDomains = array();

$jioVod = $db->read("connections","id = ?",array(66));
$jioVodDomain = $jioVod[0]['password'];
$jioVod2 = $db->read("connections","id = ?",array(69));
$jioVodDomain2 = $jioVod2[0]['password'];
$jioVod3 = $db->read("connections","id = ?",array(74));
$jioVodDomain3 = $jioVod3[0]['password'];

$tokenData = $db->read("connections","id = ?",array(60));
$token = $tokenData[0]['password'];

$jioVodDomains["1"] = $jioVodDomain;
$jioVodDomains["2"] = $jioVodDomain2;
$jioVodDomains["3"] = $jioVodDomain3;

foreach($years as $year){
    for ($i = 1; $i <= 30; $i++){
        try{
            $resp = \Tmdb::getPopularMovies($i,$year);
        }
        catch (Exception $e){
            $resp = false;
        }

        if($resp)
        {
            foreach ($resp['results'] as $movie){
                            $stream = "";
                            var_dump($movie["title"]);
                            $title = $movie["title"];
                            $streamId = $title;
                            $streamId = str_replace(":","",$streamId);
                            $streamId = str_replace("-","",$streamId);
                            $streamId = str_replace("'","",$streamId);

                            $exists = false;
                            
                            foreach ($jioVodDomains as $key => $jioDomain) {
                                $streamId_temp = "";
                                $api_domain = "";
                                if ($key == "1"){
                                    $streamId_temp = str_replace(" ","",$streamId);
                                    $api_domain = "/jiovod/";
                                }
                                if ($key == "2"){
                                    $streamId_temp = str_replace(" ",".",$streamId);
                                    $api_domain = "/jiovod2/";
                                }
                                if ($key == "3"){
                                    $streamId_temp = str_replace(" ","_",$streamId);
                                    $api_domain = "/jiovod3/";
                                }

                                $streamId_temp = urlencode($streamId_temp);
                                $stream = $publicUrl.$api_domain.$streamId_temp;

                                $file = $jioDomain.$streamId_temp.".mp4/index.m3u8?token=".$token;
                                $file_headers = @get_headers($file);
                                if($file_headers && ($file_headers[0] == 'HTTP/1.0 200 OK')) {
                                    $exists = true;
                                }
                                if($file_headers) {
                                    var_dump($file_headers[0]);
                                }


                            }

                                    
                            if($exists)
                            {
                               var_dump($file);
                               var_dump($exists);
                               var_dump($stream);
                                $date = date("Y-m-d H:i:s");
                                $added = $date;
                                //$added = date("Y-m-d H:i:s", strtotime($movie["release_date"]));
                                $categoryId = $db_vod_categories["MOVIES 2020-2016"];

                                $description = $movie["overview"];
                                $year = date("Y", strtotime($movie["release_date"]));
                                $rating_mpaa = "";
                                $age = "";
                                $rating_kinopoisk = $movie["vote_average"];
                                $kinopoisk_id = "";
                                $rating_count_imdb = intval($movie["vote_average"]);
                                $country = "";
                                $actors = "";
                                $director = "";
                                $autocomplete_provider = "tmdb";

                                $movie_added = $db->read('video','upper(name) = ? AND is_series LIKE ?',array(strtoupper($title),"0"));
                                if(!($movie_added)){

                                        $postdata = array(
                                            "name" => $title,
                                            "o_name" => $title,
                                            "description" => $description,
                                            "path" => str_replace(" ", "_", $title)."_".$year,
                                            "category_id" => $categoryId,
                                            "director" => $director,
                                            "actors" => $actors,
                                            "year" => $year,
                                            "protocol" => "",
                                            "added" => $added,
                                            "accessed" => 1,
                                            "status" => 1,
                                            "kinopoisk_id" => $kinopoisk_id,
                                            "rating_kinopoisk" => $rating_kinopoisk,
                                            "rating_count_imdb" => $rating_count_imdb,
                                            "age" => $age,
                                            "rating_mpaa" => $rating_mpaa,
                                            "high_quality" => 1,
                                            "country" => $country,
                                            "autocomplete_provider" => $autocomplete_provider,
                                            "is_series" => 0,
                                            "server" => 2
                                        );
                                        $movieId = $db->create('video',$postdata);
                                        var_dump($movie["title"]." added");



                                        $postdata = array(
                                            "video_id" => $movieId,
                                            "file_type" => "video",
                                            "protocol" => "custom",
                                            "url" => $stream,
                                            "languages" => 'a:1:{i:0;s:2:"en";}',
                                            "accessed" => 1,
                                            "status" => 1,
                                            "date_add" => $added,
                                            "date_modify" => $added,
                                            "tmp_link_type" => "nginx",
                                            "server" => 2
                                        );
                                        $video_series_file_id = $db->create('video_series_files',$postdata);

                                        $updatedata = array(
                                            "status" => 1
                                        );
                                        $db->update('video', $updatedata, 'id = :id', array(':id' => $movieId));

                                        //save image
                                        if($movie["poster_path"]!=""){

                                            $postdata = array(
                                                "name" => $movieId,
                                                "size" => 0,
                                                "type" => 'image/jpeg',
                                                            "media_id" => $movieId
                                            );
                                            $screenshot_id = $db->create('screenshots',$postdata);
                                            $updatedata = array(
                                                "name" => $screenshot_id.'.jpg',
                                            );
                                            $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

                                            $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
                                            if (!is_dir($dir_name))
                                            {
                                                mkdir($dir_name, 0755, true);
                                            }

                                            $content = file_get_contents("http://image.tmdb.org/t/p/w185".$movie["poster_path"]);
                                            $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
                                            fwrite($fp, $content);
                                            fclose($fp);
                                        }
                                }
                                else{
                                    $movieId = $movie_added[0]['id'];
                                }

                            }
            }
        }

    }
}
