<?php

require_once 'config.php';

require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once 'tmdb.class.php';

header('Content-Type: application/json');

$db = new db();
$url = "";
$active_channels = array();
$vod_groups = array();
$itv_groups = array();
$itv_group_ids = array();
$nitro_groups = array(
    "NETWORKS",
    "ENTERTAINMENT",
    "MOVIES PREMIUM",
    "NEWS",
    "KIDS",
    "SPORTS (USA/CA)",
    "UK SPORTS & INTL",
    "BEIN & ELEVEN SPORTS",
    "SKY SPORTS",
    "ESPN+ & COLLEGE EXTRA",
    "NBA LEAGUE PASS",
    "NHL CENTER ICE",
    "MLB EXTRA INNINGS",
    "NBC GOLD",
    "NFL SUNDAY TICKET",
    "PPV EVENTS (DAY OF ONLY)",
    "UFC FIGHT PASS",
    "CANADA",
    "U.K.",
    "PPV MOVIES",
    "MUSIC CHOICE",
    "MOVIES PLUS (DUAL AUDIO)",
    "24/7"
);

$ignore_groups = array(
    "PUNJABI",
    "ARABIC (NEW)",
    "FILIPINO/TAGALOG",
    "HINDI SERIALS",
    "ASIAN CINEMA"
);

$server = 1;
$items = array();

//get DB movies
$movies = array();
$moviesIds = array();
$moviesData = $db->read('video','is_series LIKE ?',array("0"));
foreach ($moviesData as $movieData){
    $movies[$movieData["name"]] = $movieData["name"];
    $moviesIds[] = $movieData["id"];
}


//get DB series
$series = array();
$seriesIds = array();
$seriesData = $db->read('video','is_series LIKE ?',array("1"));
foreach ($seriesData as $serieData){
    $series[$serieData["name"]] = $serieData["name"];
    $seriesIds[] = $serieData["id"];
}

//get DB channels
$channels = array();
$channelIds = array();
//$channelsData = $db->read('itv');
$channelsData = $db->read('itv','server = ?',array($server));
foreach ($channelsData as $channelData){
    $channels[strtoupper($channelData["name"])] = strtoupper($channelData["name"]);
    $channelIds[] = $channelData["streamId"];
}


$db_vod_categories = array();
$categoriesData = $db->read('media_category');
foreach ($categoriesData as $categoryData){
    $db_vod_categories[strtoupper($categoryData["category_name"])] = $categoryData["id"];
}


//get DB live categories
$db_categories = array();
$categoriesData = $db->read('tv_genre');
foreach ($categoriesData as $categoryData){
        $db_categories[strtoupper($categoryData["title"])] = $categoryData["id"];
}

for ($i = 1; $i <= 40; $i++){
    $resp = file_get_contents("https://www.episodate.com/api/most-popular?page=".$i);
    if($resp)
    {
        $results = json_decode($resp,true);
        if(isset($results["tv_shows"]))
        {
            $tv_shows = $results["tv_shows"];
            foreach ($tv_shows as $tv_show){
                var_dump($tv_show["name"]);
                $resp_details = file_get_contents("https://www.episodate.com/api/show-details?q=".$tv_show["id"]);
                if($resp_details)
                {
                    $resp_details = json_decode($resp_details,true);
                    if(isset($resp_details["tvShow"]))
                    {
                    	$tvShow = $resp_details["tvShow"];
                        $episodes = $resp_details["tvShow"]["episodes"];
                        foreach ($episodes as $episode){


							$id = $tv_show["id"];
							$title = $tv_show["name"];

						    if(is_numeric ($id)){

						        $season_number = intval($episode["season"]);
						        $episode_number = intval($episode["episode"]);
						        $title_series = $title;

						        $title_season = "Season ".(string) $season_number;
						        $title_episode = "Episode ".(string) $episode_number;;

						        $categoryId = $db_vod_categories["TV SHOWS - CURRENT"];

						        $seriesCount = count($series)+1;
						        $date = date("Y-m-d H:i:s");


						        $streamId = strtolower($title);
						        $streamId = str_replace(" ","",$streamId);
						        $streamId = str_replace(":","",$streamId);
						        $streamId = str_replace("-","",$streamId);
						        $streamId = str_replace("'","",$streamId);
						        $streamId = str_replace(".","",$streamId);
						        $streamId = str_replace("specialvictimsunit","svu",$streamId);
						        if($season_number >= 10)
						        {
						        	$streamId = $streamId."S".$season_number;
						        }
						        else{
						        	$streamId = $streamId."S0".$season_number;
						        }

						        if($episode_number >= 10)
						        {
						        	$streamId = $streamId."E".$episode_number;
						        }
						        else{
						        	$streamId = $streamId."E0".$episode_number;
						        }

						        $stream = $publicUrl."/jioseries/".$streamId;

								$exists = false;
                        					$jioSeries = $db->read("connections","id = ?",array(65));
                        					$jioSeriesDomain = $jioSeries[0]['password'];
                                                                $tokenData = $db->read("connections","id = ?",array(77));
                                                                $token = $tokenData[0]['password'];
								$file = $jioSeriesDomain.$streamId.".mp4/index.m3u8?token=".$token;
								$file_headers = @get_headers($file);
                                                                var_dump($file_headers[0]);
								if($file_headers && ($file_headers[0] == 'HTTP/1.0 200 OK')) {
								    $exists = true;
								}


								if($exists)
								{
							        $description = $tvShow["description"];
							        $year = date("Y", strtotime($tv_show["start_date"]));
							        $rating_mpaa = $tvShow["rating"];
							        $age = "";
							        $rating_kinopoisk = $tvShow["rating"];
							        $kinopoisk_id = "";
							        $rating_count_imdb = intval($tvShow["rating"]);
							        $country = $tv_show["country"];
							        $actors = "";
							        $director = "";
							        $autocomplete_provider = "tmdb";

							        $series_added = $db->read('video','upper(name) = ? AND is_series LIKE ?',array(strtoupper($title_series),"1"));
							        if(!($series_added)){

							                $postdata = array(
							                    "name" => $title_series,
							                    "o_name" => $title_series,
							                    "description" => $description,
							                    "path" => str_replace(" ", "_", $title_series)."_".$year,
							                    "category_id" => $categoryId,
							                    "director" => $director,
							                    "actors" => $actors,
							                    "year" => $year,
							                    "protocol" => "",
							                    "added" => $date,
							                    "accessed" => 1,
							                    "status" => 1,
							                    "kinopoisk_id" => $kinopoisk_id,
							                    "rating_kinopoisk" => $rating_kinopoisk,
							                    "rating_count_imdb" => $rating_count_imdb,
							                    "age" => $age,
							                    "rating_mpaa" => $rating_mpaa,
							                    "high_quality" => 1,
							                    "country" => $country,
							                    "autocomplete_provider" => $autocomplete_provider,
							                    "is_series" => 1
							                );
							                $movieId = $db->create('video',$postdata);
							                $series[$title_series] = $title_series;
							                $seriesIds[] = $movieId;

							                //save image
							                if($tv_show["image_thumbnail_path"]!=""){

							                        $postdata = array(
							                            "name" => $movieId,
							                            "size" => 0,
							                            "type" => 'image/jpeg',
							                                        "media_id" => $movieId
							                        );
							                        $screenshot_id = $db->create('screenshots',$postdata);
							                        $updatedata = array(
							                            "name" => $screenshot_id.'.jpg',
							                        );
							                        $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

							                        $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
							                        if (!is_dir($dir_name))
							                        {
							                            mkdir($dir_name, 0755, true);
							                        }

							                        $content = file_get_contents($tv_show["image_thumbnail_path"]);
							                        $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
							                        fwrite($fp, $content);
							                        fclose($fp);
							                }
							        }
							        else{
							            $movieId = $series_added[0]['id'];
							        }

							        $season_added = $db->read('video_season','season_name = ? AND video_id = ?',array($title_season,$movieId));
							        if(!($season_added)){
							                    $postdata = array(
							                        "video_id" => $movieId,
							                        "season_number" => $season_number,
							                        "season_name" => $title_season,
							                        "season_original_name" => $title_season,
							                        "date_add" => $date,
							                        "date_modify" => $date
							                    );
							                    $video_season_id = $db->create('video_season',$postdata);
							        }
							        else{
							            $video_season_id = $season_added[0]['id'];
							        }

							        $episode_added = $db->read('video_season_series','series_name = ? AND season_id = ?',array($title_episode,$video_season_id));
							        if(!($episode_added)){

							        	if(strtotime($episode["air_date"]) && (time() > strtotime($episode["air_date"])))
							        	{
								            $postdata = array(
								                "season_id" => $video_season_id,
								                "series_number" => $episode_number,
								                "series_name" => $title_episode,
								                "series_original_name" => $title_episode,
								                "date_add" => $date,
								                "date_modify" => $date,
								                            "series_files" => 1
								            );
								            $video_season_series_id = $db->create('video_season_series',$postdata);

								            $postdata = array(
								                "video_id" => $movieId,
								                "series_id" => $video_season_series_id,
								                "file_type" => "video",
								                "protocol" => "custom",
								                "url" => $stream,
								                            "languages" => 'a:1:{i:0;s:2:"en";}',
								                            "accessed" => 1,
								                "status" => 1,
								                "date_add" => $date,
								                "date_modify" => $date,
								                "tmp_link_type" => "nginx"
								            );
								            $video_series_file_id = $db->create('video_series_files',$postdata);

								            $updatedata = array(
								                "added" => $date,
								                "status" => 1
								            );
								            $db->update('video', $updatedata, 'id = :id', array(':id' => $movieId));


								            echo "new added episode"." ".$title_episode;
								            var_dump($title_series);
							        	}
							        }
							        else{
							        	$video_season_series_id = $episode_added[0]['id'];
							        	if(!(strtotime($episode["air_date"]) && (time() > strtotime($episode["air_date"]))))
							        	{
										   $db->delete('video_series_files', 'series_id = :series_id AND video_id = :video_id', array(':series_id' => $video_season_series_id,':video_id' => $movieId));
										   $db->delete('video_season_series', 'id = :id', array(':id' => $video_season_series_id));
							        	}
							        }

							        //$moviesCount++;
							        //$count++;

								}
						    }


                        }
                    }
                }
            }
        }
    }

}
