<?php

require_once 'config.php';

require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once 'tmdb.class.php';

header('Content-Type: application/json');

$db = new db();
$url = "";

$vod_groups = array();

$ignore_groups = array(
    "PUNJABI",
    "ARABIC (NEW)",
    "FILIPINO/TAGALOG",
    "HINDI SERIALS",
    "ASIAN CINEMA"
);

$server = 1;
$items = array();

//get DB movies
$movies = array();
$moviesIds = array();
$moviesData = $db->read('video','is_series LIKE ?',array("0"));
foreach ($moviesData as $movieData){
    $movies[$movieData["name"]] = $movieData["name"];
    $moviesIds[] = $movieData["id"];
}


//get DB series
$series = array();
$seriesIds = array();
$seriesData = $db->read('video','is_series LIKE ?',array("1"));
foreach ($seriesData as $serieData){
    $series[$serieData["name"]] = $serieData["name"];
    $seriesIds[] = $serieData["id"];
}


$db_vod_categories = array();
$categoriesData = $db->read('media_category');
foreach ($categoriesData as $categoryData){
    $db_vod_categories[strtoupper($categoryData["category_name"])] = $categoryData["id"];
}


//get DB live categories
$db_categories = array();
$categoriesData = $db->read('tv_genre');
foreach ($categoriesData as $categoryData){
        $db_categories[strtoupper($categoryData["title"])] = $categoryData["id"];
}

$file = "/home/coders/vod.json";
$vods = json_decode(file_get_contents($file), true);

foreach($vods as $vod){

    $date = date("Y-m-d H:i:s");
    $name = $vod['name'];
    //var_dump("processing ".$name." ...");


    $categoryId = 0;
    $categoryName = trim(strtoupper($vod["category_title"]));
    if (isset($db_vod_categories[trim(strtoupper($vod["category_title"]))])) {
        $categoryId = $db_vod_categories[trim(strtoupper($vod["category_title"]))];
    }
    else{
        if ((strpos($categoryName, 'MAINTENANCE') === false) && ($categoryName != "")){
            $category_alias = str_replace(" ", "_", $categoryName);
            $postdata = array(
                "category_name" => $categoryName,
                "category_alias" => strtolower($category_alias),
            );
            $categoryId = $db->create('media_category',$postdata);

            $updatedata = array(
            "num" => intval($categoryId),
            );
            $db->update('media_category', $updatedata, 'id = :id', array(':id' => "$categoryId"));
            $db_vod_categories[$categoryName] = $categoryId;
        }
    }

    if (!$categoryId){
        continue;
    }

    $is_series = 0;
    if (isset($vod['season_id']) && $vod['season_id']){
        $is_series = 1;
    }

    $movie_added = $db->read('video','upper(name) = ? AND is_series LIKE ? AND category_id = ?',array(strtoupper($name),$is_series,$categoryId));
    if(!($movie_added)) {

        $postdata = array(
            "name" => $vod["name"],
            "o_name" => $vod["o_name"],
            "description" => $vod["description"],
            "path" => $vod["path"],
            "category_id" => $categoryId,
            "director" => $vod["director"],
            "actors" => $vod["actors"],
            "year" => $vod["year"],
            "protocol" => "",
            "added" => $date,
            "accessed" => 1,
            "status" => 1,
            "kinopoisk_id" => $vod["kinopoisk_id"],
            "rating_kinopoisk" => $vod["rating_kinopoisk"],
            "rating_count_imdb" => $vod["rating_count_imdb"],
            "age" => $vod["age"],
            "rating_mpaa" => $vod["rating_mpaa"],
            "high_quality" => 1,
            "country" => $vod["country"],
            "autocomplete_provider" => $vod["autocomplete_provider"],
            "is_series" => $is_series,
            "server" => 2,
            "added" => $vod["added"]
        );
        $movieId = $db->create('video',$postdata);
        var_dump($vod["name"]." added");

        //save image
        if($vod["screenshot_uri"]!=""){

            $postdata = array(
                "name" => $movieId,
                "size" => 0,
                "type" => 'image/jpeg',
                "media_id" => $movieId,
                "url" => "http://new.jiotv.be".$vod["screenshot_uri"]
            );
            $screenshot_id = $db->create('screenshots',$postdata);
            $updatedata = array(
                "name" => $screenshot_id.'.jpg',
            );
            $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

            $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
            if (!is_dir($dir_name))
            {
                mkdir($dir_name, 0755, true);
            }

            /*$opts = array(
                'http'=>array(
                'method'=>"GET",
                'header'=>"User-Agent: lashaparesha api script\r\n"
            ));
            $context = stream_context_create($opts);

            $content = file_get_contents("http://new.jiotv.be".$vod["screenshot_uri"], false, $context);
            $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
            fwrite($fp, $content);
            fclose($fp);

            $updatedata = array(
                "screenshot" => $dir_name."/".$screenshot_id.".jpg",
                "thumbnail_url" => "http://new.jiotv.be".$vod["screenshot_uri"]
            );
            $db->update('video', $updatedata, 'id = :id', array(':id' => $movieId));*/
        }

    }
    else{
        $movieId = $movie_added[0]['id'];
    }

    if (!$is_series){

        $link_added = $db->read('video_series_files','video_id = ?',array($movieId));
        if(!($link_added)){
            $postdata = array(
                "video_id" => $movieId,
                "file_type" => "video",
                "protocol" => "custom",
                "url" => $vod["cmd"],
                "languages" => 'a:1:{i:0;s:2:"en";}',
                "accessed" => 1,
                "status" => 1,
                "date_add" => $vod["date_add"],
                "date_modify" => $vod["date_add"],
                "name" => $vod["link_name"],
                "tmp_link_type" => "nginx",
                "server" => 2
            );
            $video_series_file_id = $db->create('video_series_files',$postdata);

            $updatedata = array(
                "status" => 1
            );
            $db->update('video', $updatedata, 'id = :id', array(':id' => $movieId));
        }

    } else{

        $season_added = $db->read('video_season','season_number = ? AND video_id = ?',array($vod['season_number'],$movieId));
        if(!($season_added)){
                    $postdata = array(
                        "video_id" => $movieId,
                        "season_number" => $vod['season_number'],
                        "season_name" => "Season ".$vod['season_number'],
                        "season_original_name" => "Season ".$vod['season_number'],
                        "date_add" => $vod["date_add"],
                        "date_modify" => $vod["date_add"]
                    );
                    $video_season_id = $db->create('video_season',$postdata);
        }
        else{
            $video_season_id = $season_added[0]['id'];
        }

        $episode_added = $db->read('video_season_series','series_number = ? AND season_id = ?',array($vod['episode_number'],$video_season_id));
        if(!($episode_added)){

            $postdata = array(
                "season_id" => $video_season_id,
                "series_number" => $vod['episode_number'],
                "series_name" => "Episode ".$vod['episode_number'],
                "series_original_name" => "Episode ".$vod['episode_number'],
                "date_add" => $vod["date_add"],
                "date_modify" => $vod["date_add"],
                "series_files" => 1
            );
            $video_season_series_id = $db->create('video_season_series',$postdata);

            $postdata = array(
                "video_id" => $movieId,
                "series_id" => $video_season_series_id,
                "file_type" => "video",
                "protocol" => "custom",
                "url" => $vod["cmd"],
                "languages" => 'a:1:{i:0;s:2:"en";}',
                "accessed" => 1,
                "status" => 1,
                "date_add" => $vod["date_add"],
                "date_modify" => $vod["date_add"],
                "tmp_link_type" => "nginx"
            );
            $video_series_file_id = $db->create('video_series_files',$postdata);

            $updatedata = array(
                "added" => $date,
                "status" => 1
            );
            $db->update('video', $updatedata, 'id = :id', array(':id' => $movieId));


            echo "added episode"." ".$vod['episode_number'];
        }
        else{
            $video_season_series_id = $episode_added[0]['id'];
        }

    }

}
