<?php

require_once __DIR__ .'/config.php';
require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once __DIR__ .'/tmdb.class.php';

//get DB channels
$channels = array();
$db = new db();
$channelsData = $db->read('itv');
$channels_processed = array();
foreach ($channelsData as $channelData){
    if(!isset($channels[$channelData["xmltv_id"]]))
    {
      $channels[$channelData["xmltv_id"]] = array();
    }
    $channels[$channelData["xmltv_id"]][] = $channelData["id"];
}

$lastTime = 0;
$epgData = $db->read('epg','server = ? ORDER BY time DESC LIMIT 1',array(0));
foreach ($epgData as $epg){
    $lastTime = strtotime($epg["time"]);
}

$offset = 3600*5;
$stop_datetime = date('Y-m-d H:00:00');
$url = __DIR__."/xmltv.xml";
//$url = "http://ok2.se:8000/xmltv.php?username=coders01&password=LljdV4qAak&type=m3u_plus";
$xml = simplexml_load_file($url);
foreach ($xml as $programme){
    if($programme->title!=""){
        $channel = trim($programme["channel"]);
        if(isset($channels[$channel])){
            $name = utf8_decode($programme->title);
            $desc = utf8_decode($programme->desc);
            //$name = $programme->title;
            //$desc = $programme->desc;
            $start = $programme["start"];
            $stop = $programme["stop"];
            $start_datetime = substr($start, 0, 4)."-".substr($start, 4, 2)."-".substr($start, 6, 2)." ".substr($start, 8, 2).":".substr($start, 10, 2).":".substr($start, 12, 2);
            $stop_datetime = substr($stop, 0, 4)."-".substr($stop, 4, 2)."-".substr($stop, 6, 2)." ".substr($stop, 8, 2).":".substr($stop, 10, 2).":".substr($stop, 12, 2);
            $start_datetime = date('Y-m-d H:i:s',(strtotime($start_datetime)+($offset)));
            $stop_datetime = date('Y-m-d H:i:s',(strtotime($stop_datetime)+($offset)));
            $duration = strtotime($stop_datetime)-strtotime($start_datetime);
                if(isset($channels[$channel])){
                  $ch_ids = $channels[$channel];
                  foreach ($ch_ids as $ch_id) {
                    $lastTime = 0;
                    $epgData = $db->read('epg','ch_id = ? ORDER BY id DESC LIMIT 1',array($ch_id));
                    foreach ($epgData as $epg){
                        $lastTime = strtotime($epg["time_to"]);
                    }

                    $channels_processed[] = $ch_id;
                    $real_id = $ch_id."_".strtotime($start_datetime);
                    if(strtotime($start_datetime)>$lastTime){
                            $postdata = array(
                                    "ch_id" => $ch_id,
                                    "time" => $start_datetime,
                                    "time_to" => $stop_datetime,
                                    "duration" => $duration,
                                    "name" => $name,
                                    "descr" => "",
                                    "real_id" => $real_id,
                                    "server" => 1
                            );
                            $epgId = $db->create('epg',$postdata);
                            var_dump($epgId." added");
                    }
                  }
                }
        }
    }
}
echo "DONE";
exit;
