<?php

require_once __DIR__.'/config.php';
require_once __DIR__ . '/../libraries/pdo_wrapper.php';

$db = new db();

$transactionFiles = glob('/home/coders/transactions/*');
foreach ($transactionFiles as $file) {
    var_dump("processing ".$file." ...");
    $transactions = json_decode(file_get_contents($file), true);
    foreach ($transactions as $transaction){
        //var_dump("transaction ".$transaction['real_id']." ...");
        $real_id = $transaction['real_id'];
        $ch_id = $transaction['ch_id'];
        $epgData = $db->read('epg','ch_id = ? AND server = ? AND real_id = ? ORDER BY time DESC LIMIT 1',array($ch_id,2,$real_id));
        if ($epgData) {
            continue;
        }
        $transaction['name'] = utf8_decode($transaction['name']);
        $transaction['descr'] = utf8_decode($transaction['descr']);
        $epgId = $db->create('epg',$transaction);
        var_dump("added entry for channel ".$ch_id.": ".$transaction['name']);

    }
}
echo "DONE";
exit;

//add fake EPG for empty channels 
$end_datetime = date('Y-m-d H:00:00',time()+18000);
$channelsData = $db->read('itv','server=? AND status=? AND tv_genre_id IN (1,2,3,4,5,6,7,8,20)', array(2,1));
$count = 0;
foreach ($channelsData as $channelData){
    $lastTime = 0;
    $epgData = $db->read('epg','ch_id = ? AND name = ? ORDER BY id DESC LIMIT 1',array($channelData['id'],$channelData['name']));
    if (!$epgData){
        $epgData = $db->read('epg','ch_id = ? ORDER BY id DESC LIMIT 1',array($channelData['id']));
        if ($epgData){
            continue;
        }
    }
    foreach ($epgData as $epg){
        $lastTime = strtotime($epg["time_to"]);
    }
    $start_datetime = ($lastTime)? date('Y-m-d H:i:s',$lastTime):date('Y-m-d H:00:00',time()-259200);
    while(strtotime($start_datetime) < strtotime($end_datetime)) {
        $ch_id = $channelData['id'];
        $stop_datetime = date('Y-m-d H:i:s',(strtotime($start_datetime." +60 minutes")));
        $duration = strtotime($stop_datetime)-strtotime($start_datetime);
        $real_id = $ch_id."_".strtotime($start_datetime);

        $postdata = array(
            "ch_id" => $ch_id,
            "time" => $start_datetime,
            "time_to" => $stop_datetime,
            "duration" => $duration,
            "name" => $channelData['name'],
            "descr" => "",
            "real_id" => $real_id
        );
        $epgData = $db->read('epg','ch_id = ? AND server = ? AND real_id = ? ORDER BY time DESC LIMIT 1',array($ch_id,2,$real_id));
        if (!$epgData) {
            $epgId = $db->create('epg',$postdata);
        }
        var_dump($channelData['name']." added");

        $start_datetime = $stop_datetime;
    }
    $count++;
}
echo "DONE!";
