<?php

class Db {
	protected static $_connected = false;
	protected static $_db;
	protected static $_config;
	protected static $_lastSth;
    protected static $_stats = array("req_count" => 0);

	/**
	 * [_connect description]
	 * @return [type] [description]
	 */
	protected static function _connect(){
		if(!self::$_connected) {

	        /* set exception mode */
			$opt = array(
			    PDO::ATTR_ERRMODE	=> PDO::ERRMODE_EXCEPTION
			);
	        /* connect to database */
	        try {
	            self::$_db = new PDO(
	                sprintf(
	                    'mysql:host=%s;dbname=%s',
                        DB_HOST,
                        DB_NAME
	                ),
                    DB_USER,
                    DB_PASSWORD,
	                $opt
	            );
	            self::$_db->exec("set names latin1");
	            self::$_connected = true;

	        } catch (PDOException $e) {
	            self::_handleError("Database Connection Error!: " . $e->getMessage(), $e->getTraceAsString());
				die();
	        }
		}
	}
	/**
	 * [getRow description]
	 * @param  [type] $sql   [description]
	 * @param  array  $binds [description]
	 * @return [type]        [description]
	 */
	public static function getRow($sql, $binds=array()) {
		self::_connect();

		try {
			$sth = self::$_db->prepare($sql);
		    $sth->execute($binds);
		    $row = $sth->fetch(PDO::FETCH_ASSOC);
		    self::$_lastSth = $sth;
            self::incrReqCount();
		    return $row;

		} catch(PDOException $e) {
			self::_handleError("Database Query Error!: " . $e->getMessage(), $e->getTraceAsString());
			die();
		}
	}
	/**
	 * [getAll description]
	 * @param  [type] $sql        [description]
	 * @param  array  $binds      [description]
	 * @param  [type] $fetchStyle [description]
	 * @param  [type] $fetchArg   [description]
	 * @return [type]             [description]
	 */
	public static function getAll($sql, $binds=array(), $fetchStyle=PDO::FETCH_ASSOC, $fetchArg=null) {
		self::_connect();
		try {
			$sth = self::$_db->prepare($sql);
		    $sth->execute($binds);
		    if(!is_null($fetchArg)) {
		    	$rows = $sth->fetchAll($fetchStyle, $fetchArg);

		    } else {
		    	$rows = $sth->fetchAll($fetchStyle);
		    }
		    self::$_lastSth = $sth;
            self::incrReqCount();
		    return $rows;

		} catch(PDOException $e) {
			self::_handleError("Database Query Error!: " . $e->getMessage(), $e->getTraceAsString());
			die();
		}
	}
	/**
	 * [getValue description]
	 * @param  [type] $sql   [description]
	 * @param  array  $binds [description]
	 * @return [type]        [description]
	 */
	public static function getValue($sql, $binds=array()) {
		self::_connect();
		try {
			$sth = self::$_db->prepare($sql);
		    $sth->execute($binds);
		    $value = $sth->fetchColumn();
		    self::$_lastSth = $sth;
            self::incrReqCount();
		    return $value;

		} catch(PDOException $e) {
			self::_handleError("Database Query Error!: " . $e->getMessage(), $e->getTraceAsString());
			die();
		}
	}
	/**
	 * [execute description]
	 * @param  [type] $sql   [description]
	 * @param  array  $binds [description]
	 * @return [type]        [description]
	 */
	public static function execute($sql, $binds=array()) {
		self::_connect();
		try {
			$sth = self::$_db->prepare($sql);

			foreach($binds as $key => $value) {
				if(is_null($value)) {
					$sth->bindParam($key, $binds[$key], PDO::PARAM_NULL);

				} else {
					$sth->bindParam($key, $binds[$key]);
				}
			}
		    $result = $sth->execute();
		    self::$_lastSth = $sth;
            self::incrReqCount();
		    return $result;

		} catch(PDOException $e) {
			self::_handleError("Database Execute Error!: " . $e->getMessage(), $e->getTraceAsString());
			die();
		}
	}
	/**
	 * [insert description]
	 * @param  [type] $table [description]
	 * @param  [type] $data  [description]
	 * @return [type]        [description]
	 */
	public static function insert($table, $data) {
		$fields = array_keys($data);
		$bindNames = array();

		foreach($fields as $name) {
			$name = trim($name);
			$bindNames[] = ":".$name;
		}
		$binds = array_combine($bindNames, $data);

		/* change the name of the binds */
		$fields = implode(',', $fields);
		$bindNames = implode(',', $bindNames);

		$sql = "INSERT INTO {$table} ({$fields}) VALUES({$bindNames})";
		$result = self::execute($sql, $binds);

		return $result?self::$_db->lastInsertId():$result;
	}
	/**
	 * [update description]
	 * @param  [type]  $table     [description]
	 * @param  [type]  $data      [description]
	 * @param  integer $condition [description]
	 * @return [type]             [description]
	 */
	public static function update($table, $data, $condition = 1) {
		$binds = array();
		$fields = array();

		foreach($data as $name => $value) {
			$name = trim($name);
			$fields[] = sprintf("%s=%s", $name, ":".$name);
			$binds[":".$name] = $value;
		}
		$fields = implode(",", $fields);
		$sql = "UPDATE {$table} SET {$fields} WHERE {$condition}";
		$result = self::execute($sql, $binds);
		return $result;
	}
	/**
	 * [getMetaName description]
	 * @return [type] [description]
	 */
	public static function getMetaName(){
		$totalColumn = self::$_lastSth->columnCount();
		$metadata = array();

		for ($counter = 0; $counter <= $totalColumn; $counter++) {
		    $meta = self::$_lastSth->getColumnMeta($counter);
		    $metadata[$counter] = $meta['name'];
		}
		return $metadata;
	}
	/**
	 * [quote description]
	 * @param  [type] $value [description]
	 * @return [type]        [description]
	 */
	public static function quote($value) {
		return self::$_db->quote($value);
	}
	/**
	 * [rowCount description]
	 * @return [type] [description]
	 */
	public static function rowCount(){
		return self::$_lastSth->rowCount();
	}
	/**
	 * [_handleError description]
	 * @param  [type] $message [description]
	 * @param  string $trace   [description]
	 * @return [type]          [description]
	 */
	protected static function _handleError($message, $trace="") {
	    error_log($message, 0);
	}
    protected static function incrReqCount() {
        self::$_stats['req_count'] = self::$_stats['req_count'] + 1;
    }
    public static function getStats() {
        return self::$_stats;
    }
}