<?php

require_once 'config.php';

require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once 'tmdb.class.php';

$initial_channels_add = 1;

//get Remote categories
$categories = array();
$url = $apiUrl."&type=get_vod_categories";
$xml = simplexml_load_file($url);
foreach ($xml as $channel){
	$title = base64_decode($channel->title);
	if(($title!="All") && ($title!="")){
		$category_id = $channel->category_id;
		$categories[strtoupper($title)] = $category_id;
	}
}

//get DB categories
$db_categories = array();
$db = new db();
$categoriesData = $db->read('media_category');
foreach ($categoriesData as $categoryData){
    $db_categories[strtoupper($categoryData["category_name"])] = $categoryData["id"];
}

//get DB movies
$movies = array();
$moviesIds = array();
$db = new db();
$moviesData = $db->read('video');
foreach ($moviesData as $movieData){
    $movies[$movieData["name"]] = $movieData["name"];
    $moviesIds[] = $movieData["id"];
}

$moviesCount = count($movies)+1;
$date = date("Y-m-d H:i:s");


foreach ($categories as $category=>$key){
	//add Remote channels if missing
	$categoryName = strtoupper($category);
	$url = $apiUrl."&type=get_vod_streams&cat_id=".$key;
	$xml = simplexml_load_file($url);
	$categoryId = 0;
	if(isset($db_categories[$categoryName])){
		$categoryId = $db_categories[$categoryName];
	}
	else{
		$category_alias = str_replace(" ", "_", $category);
        $postdata = array(
            "category_name" => $category,
            "category_alias" => strtolower($category_alias),
        );
        $categoryId = $db->create('media_category',$postdata);

        $updatedata = array(
            "num" => intval($categoryId),
        );
        $db->update('media_category', $updatedata, 'id = :id', array(':id' => "$categoryId"));
	}

	foreach ($xml as $channel){
	    $title = base64_decode($channel->title);
		if (strpos($title, '[') !== false) {
		    $title = substr($title, 0, strpos($title,'['));
		}
		$title = trim($title);
		var_dump($title);
	    if ($title != ""){
	        //get channel id
	        $stream_url = $channel->stream_url;
	        $url_parts = explode("/", $stream_url);
	        $url_parts_count = count($url_parts);
	        $id = $url_parts[$url_parts_count-1];
	        $id = trim(str_replace(".m3u8","",$id));
	        if(is_numeric ($id)){

	        	if($initial_channels_add){
		        	if(!(isset($movies[$title]))){
		        		var_dump($title);

			            $stream = $publicUrl."/vod/".$id;

			            $description = base64_decode($channel->description);
			            $year = "";
			            $rating_mpaa = "";
			            $age = "";
			            $rating_kinopoisk = "";
			            $kinopoisk_id = "";
			            $rating_count_imdb = 0;
			            $country = "";
			            $actors = "";
			            $director = "";
			            $autocomplete_provider = "tmdb";

			            try{
			            	$imdbData = \Tmdb::getInfoByName($title);
			            }
			            catch (Exception $e){ 
			            	$imdbData = array();
			            }
			            
			            if(count($imdbData)){
			            	$kinopoisk_id = (isset($imdbData['kinopoisk_id']))? $imdbData['kinopoisk_id']:$kinopoisk_id;
				            $description = (isset($imdbData['description']))? $imdbData['description']:$description;
				            $year = (isset($imdbData['year']))? $imdbData['year']:$year;
				            $rating_mpaa = (isset($imdbData['rating_mpaa']))? $imdbData['rating_mpaa']:$rating_mpaa;
				            $age = (isset($imdbData['age']))? $imdbData['age']:$age;
				            $rating_kinopoisk = (isset($imdbData['rating_kinopoisk']))? $imdbData['rating_kinopoisk']:$rating_kinopoisk;
				            $rating_count_imdb = (isset($imdbData['rating_count_kinopoisk']))? $imdbData['rating_count_kinopoisk']:$rating_count_imdb;
				            $country = (isset($imdbData['country']))? $imdbData['country']:$country;
				            $actors = (isset($imdbData['actors']))? $imdbData['actors']:$actors;
				            $director = (isset($imdbData['director']))? $imdbData['director']:$director;
			            }

					    $postdata = array(
				            "name" => $title,
				            "o_name" => $title,
				            "description" => $description,
				            "path" => str_replace(" ", "_", $title)."_".$year,
				            "category_id" => $categoryId,
				            "director" => $director,
				            "actors" => $actors,
				            "year" => $year,
				            "protocol" => "",
				            "added" => $date,
				            "accessed" => 1,
							"status" => 1,
							"kinopoisk_id" => $kinopoisk_id,
							"rating_kinopoisk" => $rating_kinopoisk,
							"rating_count_imdb" => $rating_count_imdb,
							"age" => $age,
							"rating_mpaa" => $rating_mpaa,
							"high_quality" => 1,
							"country" => $country,
							"autocomplete_provider" => $autocomplete_provider

				        );
				        $movieId = $db->create('video',$postdata);


				        $postdata = array(
				            "video_id" => $movieId,
				            "file_type" => "video",
				            "protocol" => "custom",
				            "url" => $stream,
							"languages" => 'a:1:{i:0;s:2:"en";}',
							"accessed" => 1,
				            "status" => 1,
				            "date_add" => $date,
						"date_modify" => $date,
				            "tmp_link_type" => "nginx"
				        );
				        $video_series_file_id = $db->create('video_series_files',$postdata);


				        //save image
			            if($channel->desc_image!=""){

						        $postdata = array(
						            "name" => $movieId,
						            "size" => 14400,
						            "type" => 'image/jpeg',
									"media_id" => $movieId
						        );
						        $screenshot_id = $db->create('screenshots',$postdata);
						        $updatedata = array(
						            "name" => $screenshot_id.'.jpg',
						        );
						        $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

						        $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
								if (!is_dir($dir_name))
								{
								    mkdir($dir_name, 0755, true);
								}

						        $content = file_get_contents($channel->desc_image);
			                    $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
			                    fwrite($fp, $content);
			                    fclose($fp);
			            }

				        $moviesCount++;
		        	}
	        	}
			}
		}
	}
}
