<?php

require_once 'config.php';

require_once __DIR__ . '/../libraries/pdo_wrapper.php';
require_once 'tmdb.class.php';

$initial_channels_add = 1;

//get Remote categories
$categories = array();
$url = $apiUrl."&type=get_series_categories";
$xml = simplexml_load_file($url);
foreach ($xml as $channel){
        $title = base64_decode($channel->title);
        if(($title!="All") && ($title!="")){
                $category_id = $channel->category_id;
                $categories[strtoupper($title)] = $category_id;
        }
}

//get DB categories
$db_categories = array();
$db = new db();
$categoriesData = $db->read('media_category');
foreach ($categoriesData as $categoryData){
    $db_categories[strtoupper($categoryData["category_name"])] = $categoryData["id"];
}

//get DB movies
$movies = array();
$moviesIds = array();
$db = new db();
$moviesData = $db->read('video');
foreach ($moviesData as $movieData){
    $movies[$movieData["name"]] = $movieData["name"];
    $moviesIds[] = $movieData["id"];
}

$moviesCount = count($movies)+1;
$date = date("Y-m-d H:i:s");


foreach ($categories as $category=>$key){
        //add Remote channels if missing
        $categoryName = strtoupper($category);
        $url = $apiUrl."&type=get_series&cat_id=".$key;
        var_dump($url);
        $xml = simplexml_load_file($url);
        $categoryId = 0;
        if(isset($db_categories[$categoryName])){
                $categoryId = $db_categories[$categoryName];
        }
        else{
                $category_alias = str_replace(" ", "_", $category);
        $postdata = array(
            "category_name" => $category,
            "category_alias" => strtolower($category_alias),
        );
        $categoryId = $db->create('media_category',$postdata);

        $updatedata = array(
            "num" => intval($categoryId),
        );
        $db->update('media_category', $updatedata, 'id = :id', array(':id' => "$categoryId"));
        }

        foreach ($xml as $series){
                $series_added = 0;
            $title_series = base64_decode($series->title);
                $title_series = trim($title_series);
                var_dump($title_series);
            if ($title_series != ""){

                $series_id = $series->category_id;
                $url_series = $apiUrl."&type=get_seasons&series_id=".$series_id;
                $xml_series = simplexml_load_file($url_series);
                var_dump($url_series);

                foreach ($xml_series as $season){
                            $title_season = base64_decode($season->title);
                                $title_season = trim($title_season);
                        if ($title_season != ""){
                                $season_added = 0;
                                $season_id = $season->category_id;
                                        $url_episodes = $apiUrl."&type=get_series_streams&series_id=".$series_id."&season=".$season_id;
                                        $xml_episodes = simplexml_load_file($url_episodes);
                                        var_dump($url_episodes);

                                        //episode count
                                        $count = 1;

                                        foreach ($xml_episodes as $episode){
                                            $title_episode = base64_decode($episode->title);
                                                $title_episode = trim($title_episode);

                                                if ($title_episode != ""){
                                                        //get channel id
                                                $stream_url = $episode->stream_url;
                                                $url_parts = explode("/", $stream_url);
                                                $url_parts_count = count($url_parts);
                                                $id = $url_parts[$url_parts_count-1];
                                                $id = trim(str_replace(".m3u8","",$id));
                                                if(is_numeric ($id)){
                                                        if(!(isset($movies[$title_series]))){

                                                            $stream = $publicUrl."/series/".$id;

                                                            $description = base64_decode($episode->description);
                                                            $year = "";
                                                            $rating_mpaa = "";
                                                            $age = "";
                                                            $rating_kinopoisk = "";
                                                            $kinopoisk_id = "";
                                                            $rating_count_imdb = 0;
                                                            $country = "";
                                                            $actors = "";
                                                            $director = "";
                                                            $autocomplete_provider = "tmdb";

                                                            if(!($series_added)){
                                                                    try{
                                                                        $imdbData = \Tmdb::getInfoByName($title_series);
                                                                    }
                                                                    catch (Exception $e){
                                                                        $imdbData = array();
                                                                    }

                                                                    if(count($imdbData)){
                                                                        $kinopoisk_id = (isset($imdbData['kinopoisk_id']))? $imdbData['kinopoisk_id']:$kinopoisk_id;
                                                                            $description = (isset($imdbData['description']))? $imdbData['description']:$description;
                                                                            $year = (isset($imdbData['year']))? $imdbData['year']:$year;
                                                                            $rating_mpaa = (isset($imdbData['rating_mpaa']))? $imdbData['rating_mpaa']:$rating_mpaa;
                                                                            $age = (isset($imdbData['age']))? $imdbData['age']:$age;
                                                                            $rating_kinopoisk = (isset($imdbData['rating_kinopoisk']))? $imdbData['rating_kinopoisk']:$rating_kinopoisk;
                                                                            $rating_count_imdb = (isset($imdbData['rating_count_kinopoisk']))? $imdbData['rating_count_kinopoisk']:$rating_count_imdb;
                                                                            $country = (isset($imdbData['country']))? $imdbData['country']:$country;
                                                                            $actors = (isset($imdbData['actors']))? $imdbData['actors']:$actors;
                                                                            $director = (isset($imdbData['director']))? $imdbData['director']:$director;
                                                                    }

                                                                            $postdata = array(
                                                                            "name" => $title_series,
                                                                            "o_name" => $title_series,
                                                                            "description" => $description,
                                                                            "path" => str_replace(" ", "_", $title_series)."_".$year,
                                                                            "category_id" => $categoryId,
                                                                            "director" => $director,
                                                                            "actors" => $actors,
                                                                            "year" => $year,
                                                                            "protocol" => "",
                                                                            "added" => $date,
                                                                            "accessed" => 1,
                                                                                        "status" => 1,
                                                                                        "kinopoisk_id" => $kinopoisk_id,
                                                                                        "rating_kinopoisk" => $rating_kinopoisk,
                                                                                        "rating_count_imdb" => $rating_count_imdb,
                                                                                        "age" => $age,
                                                                                        "rating_mpaa" => $rating_mpaa,
                                                                                        "high_quality" => 1,
                                                                                        "country" => $country,
                                                                                        "autocomplete_provider" => $autocomplete_provider,
                                                                                        "is_series" => 1

                                                                        );
                                                                        $movieId = $db->create('video',$postdata);
                                                                        $series_added = 1;
                                                            }

                                                            if(!($season_added)){
                                                                        $postdata = array(
                                                                            "video_id" => $movieId,
                                                                            "season_number" => $season_id,
                                                                            "season_name" => $title_season,
                                                                            "season_original_name" => $title_season,
                                                                            "date_add" => $date,
                                                                            "date_modify" => $date
                                                                        );
                                                                        $video_season_id = $db->create('video_season',$postdata);
                                                                        $season_added = 1;
                                                            }

                                                                $postdata = array(
                                                                    "season_id" => $video_season_id,
                                                                    "series_number" => $count,
                                                                    "series_name" => $title_episode,
                                                                    "series_original_name" => $title_episode,
                                                                    "date_add" => $date,
                                                                    "date_modify" => $date,
                                                                                "series_files" => 1
                                                                );
                                                                $video_season_series_id = $db->create('video_season_series',$postdata);


                                                                $postdata = array(
                                                                    "video_id" => $movieId,
                                                                    "series_id" => $video_season_series_id,
                                                                    "file_type" => "video",
                                                                    "protocol" => "custom",
                                                                    "url" => $stream,
                                                                                "languages" => 'a:1:{i:0;s:2:"en";}',
                                                                                "accessed" => 1,
                                                                    "status" => 1,
                                                                    "date_add" => $date,
                                                                    "date_modify" => $date,
                                                                    "tmp_link_type" => "nginx"
                                                                );
                                                                $video_series_file_id = $db->create('video_series_files',$postdata);


                                                                echo "new added episode"." ".$title_episode;
                                                                var_dump($title_series);


                                                                //save image
                                                            if($episode->desc_image!=""){

                                                                                $postdata = array(
                                                                                    "name" => $movieId,
                                                                                    "size" => 0,
                                                                                    "type" => 'image/jpeg',
                                                                                                "media_id" => $movieId
                                                                                );
                                                                                $screenshot_id = $db->create('screenshots',$postdata);
                                                                                $updatedata = array(
                                                                                    "name" => $screenshot_id.'.jpg',
                                                                                );
                                                                                $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

                                                                                $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
                                                                                        if (!is_dir($dir_name))
                                                                                        {
                                                                                            mkdir($dir_name, 0755, true);
                                                                                        }

                                                                                $content = file_get_contents($episode->desc_image);
                                                                    $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
                                                                    fwrite($fp, $content);
                                                                    fclose($fp);
                                                            }

                                                                $moviesCount++;
                                                                $count++;
                                                        }
                                                        else{

                                                            $stream = $publicUrl."/series/".$id;
                                                        $seriesData = $db->read('video','name = ?',array($title_series));
                                                        if($seriesData){
                                                                $movieId = $seriesData[0]['id'];
                                                        }

                                                            if(!($season_added)){
                                                                $seasonData = $db->read('video_season','season_name = ? AND video_id = ?',array($title_season,$movieId));
                                                                if($seasonData){
                                                                        $video_season_id = $seasonData[0]['id'];
                                                                        $season_added = 1;
                                                                }
                                                                else{
                                                                                $postdata = array(
                                                                                    "video_id" => $movieId,
                                                                                    "season_number" => $season_id,
                                                                                    "season_name" => $title_season,
                                                                                    "season_original_name" => $title_season,
                                                                                    "date_add" => $date,
                                                                                    "date_modify" => $date
                                                                                );

                                                                                $video_season_id = $db->create('video_season',$postdata);
                                                                                $season_added = 1;
                                                                    echo "existing added season"." ".$title_season;
                                                                    var_dump($title_series);
                                                                }
                                                            }


                                                        $episodeData = $db->read('video_season_series','series_name = ? AND season_id = ?',array($title_episode,$video_season_id));
                                                        if($episodeData){
                                                                $video_season_series_id = $episodeData[0]['id'];
                                                        }
                                                        else{
                                                                        $postdata = array(
                                                                            "season_id" => $video_season_id,
                                                                            "series_number" => $count,
                                                                            "series_name" => $title_episode,
                                                                            "series_original_name" => $title_episode,
                                                                            "date_add" => $date,
                                                                            "date_modify" => $date,
                                                                                        "series_files" => 1
                                                                        );
                                                                        $video_season_series_id = $db->create('video_season_series',$postdata);

                                                                        $postdata = array(
                                                                            "video_id" => $movieId,
                                                                            "series_id" => $video_season_series_id,
                                                                            "file_type" => "video",
                                                                            "protocol" => "custom",
                                                                            "url" => $stream,
                                                                                        "languages" => 'a:1:{i:0;s:2:"en";}',
                                                                                        "accessed" => 1,
                                                                            "status" => 1,
                                                                            "date_add" => $date,
                                                                            "date_modify" => $date,
                                                                            "tmp_link_type" => "nginx"
                                                                        );
                                                                        $video_series_file_id = $db->create('video_series_files',$postdata);

                                                                    echo "existing added episode"." ".$title_episode;
                                                                    var_dump($title_series);


			                                                        $screenshotData = $db->read('screenshots','name = ?',array($movieId));
			                                                        if(!($screenshotData)){
	                                                                    if($episode->desc_image!=""){

	                                                                                        $postdata = array(
	                                                                                            "name" => $movieId,
	                                                                                            "size" => 14400,
	                                                                                            "type" => 'image/jpeg',
	                                                                                                        "media_id" => $movieId
	                                                                                        );
	                                                                                        $screenshot_id = $db->create('screenshots',$postdata);
	                                                                                        $updatedata = array(
	                                                                                            "name" => $screenshot_id.'.jpg',
	                                                                                        );
	                                                                                        $db->update('screenshots', $updatedata, 'id = :id', array(':id' => $screenshot_id));

	                                                                                        $dir_name = dirname(__FILE__)."/../stalker_portal/screenshots/".ceil($screenshot_id/100);
	                                                                                                if (!is_dir($dir_name))
	                                                                                                {
	                                                                                                    mkdir($dir_name, 0755, true);
	                                                                                                }

	                                                                                        $content = file_get_contents($episode->desc_image);
	                                                                            $fp = fopen($dir_name."/".$screenshot_id.".jpg", "w");
	                                                                            fwrite($fp, $content);
	                                                                            fclose($fp);
	                                                                    }
			                                                        }
                                                        }

                                                                $moviesCount++;
                                                                $count++;
                                                        }
                                                        }
                                                }
                                        }

                        }
                }
                }
        }
}
